#region Copyright (C) 2005-2007 Benjamin Schrter <benjamin@irgendwie.net>
//
// This file is part of PhotoTagStudio
//
// PhotoTagStudio is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// PhotoTagStudio is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with PhotoTagStudio; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, 5th Floor, Boston, MA 02110-1301 USA.
#endregion

using Schroeter.PhotoTagStudio.Properties;

namespace Schroeter.PhotoTagStudio
{
    public class SettingsManager
    {
        public static void ImportOldConfig()
        {
            if (Settings.Default.NewSettingFile)
            {
                Settings.Default.Upgrade();
                Settings.Default.NewSettingFile = false;
            }
        }

        public static void InitUserSettings()
        {
            if (Settings.Default.Headlines == null)
                Settings.Default.Headlines = new TagList();

            if (Settings.Default.Captions == null)
                Settings.Default.Captions = new TagList();

            if (Settings.Default.Contacts == null)
                Settings.Default.Contacts = new TagList(true);

            if (Settings.Default.Copyrights == null)
                Settings.Default.Copyrights = new TagList(true);

            if (Settings.Default.Authors == null)
                Settings.Default.Authors = new TagList(true);

            if (Settings.Default.Writers == null)
                Settings.Default.Writers = new TagList(true);

            if (Settings.Default.Objectnames == null)
                Settings.Default.Objectnames = new TagList();

            if (Settings.Default.Locations == null)
                Settings.Default.Locations = new LocationList(true);

            if (Settings.Default.FilenameFormats == null)
            {
                Settings.Default.FilenameFormats = new TagListWithDefault(true);
                Settings.Default.FilenameFormats.Add("%dc[yyyy-MM-dd HH-mm-ss]");
            }

            if (Settings.Default.DirectorynameFormats == null)
            {
                Settings.Default.DirectorynameFormats = new TagListWithDefault(true);
                Settings.Default.DirectorynameFormats.Add("%dc[yyyy-MM-dd]");
            }

            if (Settings.Default.GroupedKeywords == null)
            {
                if (Settings.Default.Keywords == null)
                    Settings.Default.GroupedKeywords = new GroupedTagList(true);
                else
                {
                    Settings.Default.GroupedKeywords = new GroupedTagList(Settings.Default.Keywords);
                    Settings.Default.Keywords = null;
                }
            }
        }

        public static void RegisterManager()
        {
            Schroeter.Photo.PictureMetaData.RotateAsExifOrientation = Settings.Default.RotatePreview;

            Settings.Default.PropertyChanged += new System.ComponentModel.PropertyChangedEventHandler(Settings_PropertyChanged);
        }

        private static void Settings_PropertyChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
        {
            if (e.PropertyName == "RotatePreview")
                Schroeter.Photo.PictureMetaData.RotateAsExifOrientation = Settings.Default.RotatePreview;
        }
    }
}
