#region Copyright (C) 2005-2007 Benjamin Schrter <benjamin@irgendwie.net>
//
// This file is part of PhotoTagStudio
//
// PhotoTagStudio is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// PhotoTagStudio is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with PhotoTagStudio; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, 5th Floor, Boston, MA 02110-1301 USA.
#endregion

using System.IO;
using System.Text;
using System.Xml;

namespace Schroeter.KmlGenerator
{
    public class PlacemarkLine : PlacemarkBase
    {
        private Coordinates coordinates;

        public PlacemarkLine()
        {
            coordinates = new Coordinates();
        }

        public Coordinates Coordinates
        {
            get { return coordinates; }
        }

        public override XmlElement CreateXml(bool forArchiv)
        {
            Stream s = System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("Schroeter.KmlGenerator.Templates.PlacemarkLine.xml");
            XmlDocument doc = new XmlDocument();
            doc.Load(s);
            s.Close();

            XmlElement root = (XmlElement)doc.ChildNodes[1];

            XmlNamespaceManager nsmgr = new XmlNamespaceManager(doc.NameTable);
            nsmgr.AddNamespace("ns", "http://earth.google.com/kml/2.0");

            root.SelectSingleNode("/ns:Placemark/ns:name", nsmgr).InnerText = name;
            root.SelectSingleNode("/ns:Placemark/ns:description", nsmgr).AppendChild(doc.CreateCDataSection(description));

            root.SelectSingleNode("/ns:Placemark/ns:LineString/ns:coordinates", nsmgr).InnerText = MakeCoordinates();            

            return root;
        }
        
        private string MakeCoordinates()
        {
            //coordinates.RemovePeeks();
            coordinates.RemoveDuplicates();
            
            StringBuilder sb = new StringBuilder();
            
            foreach(Coordinate c in coordinates)
            {
                sb.Append(XmlConvert.ToString(c.Longitude));
                sb.Append(",");
                sb.Append(XmlConvert.ToString(c.Latitude));
                sb.Append(",");
                sb.Append(XmlConvert.ToString(c.Attitude));
                sb.Append("\n");
            }

            return sb.ToString();
        }
    }
}
