#region Copyright (C) 2005-2007 Benjamin Schrter <benjamin@irgendwie.net>
//
// This file is part of PhotoTagStudio
//
// PhotoTagStudio is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// PhotoTagStudio is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with PhotoTagStudio; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, 5th Floor, Boston, MA 02110-1301 USA.
#endregion

using System;
using System.Reflection;
using System.Windows.Forms;
using Schroeter.PhotoTagStudio.Data;
using Schroeter.PhotoTagStudio.Properties;

namespace Schroeter.PhotoTagStudio.Gui
{
    partial class StandAloneMacroExecutionForm : Form, IStatusDisplay
    {
        private const string FORM_TITLE = "PhotoTagStudio";
        private const string FORM_TITLE_WITH_PERCENT = "{0}% - PhotoTagStudio";

        private Macro macro;
        private string startDirectory;
        private bool askBeforeExecutionWhenDirectoryIsGivenFromFirstItem;

        public StandAloneMacroExecutionForm(Macro macro, string startDirectory, bool askBeforeExecutionWhenDirectoryIsGivenFromFirstItem)
        {
            this.Icon = Resources.PTS;

            this.macro = macro;
            this.startDirectory = startDirectory;
            this.askBeforeExecutionWhenDirectoryIsGivenFromFirstItem = askBeforeExecutionWhenDirectoryIsGivenFromFirstItem;

            InitializeComponent();

            this.labelName.Text = macro.Name;
            this.textDescription.Text = macro.Description;
            this.textDescription.Focus();
        }

        private void StandAloneMacroExecutionForm_Shown(object sender, EventArgs e)
        {
            MacroEditor.ExecuteMacro(macro, startDirectory, askBeforeExecutionWhenDirectoryIsGivenFromFirstItem, this, this);

            this.Close();
        }

        // mostly the same code as in StatusDisplay
        #region IStatusDisplay
        private int partCounts;

        private delegate void SimpleDelegate();
        public void WorkStart(int partCounts)
        {
            this.partCounts = partCounts;

            DoWorkStart();
        }

        private void DoWorkStart()
        {
            if (this.InvokeRequired)
                this.Invoke(new SimpleDelegate(this.DoWorkStart));
            else
            {
                progressBar1.Value = 0;
                if (statusLabel != null)
                    statusLabel.Text = "";
                progressBar1.Maximum = partCounts;

                if (progressBar1.Maximum > 3)
                    progressBar1.Visible = true;

                this.Text = FORM_TITLE;

                this.Refresh();
            }
        }

        public void WorkNextPart()
        {
            if (this.InvokeRequired)
                this.Invoke(new SimpleDelegate(this.WorkNextPart));
            else if (progressBar1.Value < progressBar1.Maximum)
            {
                progressBar1.Value++;

                if (statusLabel != null)
                    if (progressBar1.Value > 0 && progressBar1.Maximum > 3)
                    {
                        statusLabel.Text = "(" + progressBar1.Value + "/" + progressBar1.Maximum + ")";
                    }
                    else
                        statusLabel.Text = "";

                if ( progressBar1.Maximum != 0 )
                {
                    double p = progressBar1.Value/(double)progressBar1.Maximum*100;
                    this.Text = String.Format(FORM_TITLE_WITH_PERCENT,(int)p);
                }

                this.Refresh();
            }
        }

        public void WorkFinished()
        {
            if (this.InvokeRequired)
                this.Invoke(new SimpleDelegate(this.WorkFinished));
            else
            {
                progressBar1.Visible = false;
                progressBar1.Value = 0;
                if (statusLabel != null)
                    statusLabel.Text = "";

                this.Text = FORM_TITLE;

                this.Refresh();
            }
        }

        public void WorkCorrectPartCount(int partCounts)
        {
            this.partCounts = partCounts;

            DoCorrectPartCount();
        }

        private void DoCorrectPartCount()
        {
            if (this.InvokeRequired)
                this.Invoke(new SimpleDelegate(this.DoCorrectPartCount));
            else
            {
                if (progressBar1.Value > partCounts)
                    progressBar1.Value = partCounts;
                progressBar1.Maximum = partCounts;

                if (statusLabel != null)
                    if (progressBar1.Value > 0 && progressBar1.Maximum > 3)
                        statusLabel.Text = "(" + progressBar1.Value + "/" + progressBar1.Maximum + ")";
                    else
                        statusLabel.Text = "";

                if (progressBar1.Maximum > 3)
                    progressBar1.Visible = true;

                this.Refresh();
            }
        }
        #endregion
    }
}