#region Copyright (C) 2005-2007 Benjamin Schrter <benjamin@irgendwie.net>
//
// This file is part of PhotoTagStudio
//
// PhotoTagStudio is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// PhotoTagStudio is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with PhotoTagStudio; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, 5th Floor, Boston, MA 02110-1301 USA.
#endregion

using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Windows.Forms;
using Schroeter.Photo;

namespace Schroeter.PhotoTagStudio.Features.Renamer
{
    class CopyMoveController
    {
        private CopyMoveModel model;

        public CopyMoveController(CopyMoveModel m)
        {
            model = m;
        }

        public bool Work(IStatusDisplay statusDisplay)
        {
            if ( model.ForbitExecution() || model.SourceDirectory == "" )
            {
                MessageBox.Show("One of the source or destination directory is invalid!", "PhotoTagStudio", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }

            // check if source dir exists
            if ( !Directory.Exists(model.SourceDirectory) )
            {
                MessageBox.Show(String.Format("The source directory {0} does no exist!",model.SourceDirectory), "PhotoTagStudio", MessageBoxButtons.OK,
                                MessageBoxIcon.Error);
                return false;
            }

            CopyMoveWorker worker = new CopyMoveWorker(false);
            worker.CreateFileList(model);
            worker.OneFileProcessed += delegate { statusDisplay.WorkNextPart(); };
            statusDisplay.WorkStart(worker.FileCount);
            
            worker.ProcessFiles(model);

            statusDisplay.WorkFinished();

            return true;
        }
    }
}
