#region Copyright (C) 2005-2007 Benjamin Schrter <benjamin@irgendwie.net>
//
// This file is part of PhotoTagStudio
//
// PhotoTagStudio is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// PhotoTagStudio is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with PhotoTagStudio; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, 5th Floor, Boston, MA 02110-1301 USA.
#endregion

using System;
using System.Windows.Forms;

namespace Schroeter.PhotoTagStudio
{
    public class StatusDisplay : IStatusDisplay
    {
        private ToolStripProgressBar progressBar;
        private ToolStripStatusLabel statusLabel;
        private int partCounts;

        public StatusDisplay(ToolStripProgressBar progressBar) : this(progressBar, null)
        {
            
        }        
        
        public StatusDisplay(ToolStripProgressBar progressBar, ToolStripStatusLabel statusLabel)
        {
            this.progressBar = progressBar;
            this.statusLabel = statusLabel;
        }

        // mostly the same code as in StandAloneMacroExecutionForm
        #region IStatusDisplay
        private delegate void SimpleDelegate();
        public void WorkStart(int partCounts)
        {
            this.partCounts = partCounts;
            
            DoWorkStart();
        }
        
        private void DoWorkStart()
        {
            if (this.progressBar.Owner.InvokeRequired)
                this.progressBar.Owner.Invoke(new SimpleDelegate(this.DoWorkStart));
            else
            {
                progressBar.Value = 0;
                if ( statusLabel != null )
                    statusLabel.Text = "";
                progressBar.Maximum = partCounts;

                if (progressBar.Maximum > 3)
                    progressBar.Visible = true;

                this.progressBar.Owner.Refresh();
            }
        }

        public void WorkNextPart()
        {
            if (this.progressBar.Owner.InvokeRequired)
                this.progressBar.Owner.Invoke(new SimpleDelegate(this.WorkNextPart));
            else if (progressBar.Value < progressBar.Maximum)
            {
                progressBar.Value ++;

                if (statusLabel != null)
                    if (progressBar.Value > 0 && progressBar.Maximum > 3)
                        statusLabel.Text = "(" + progressBar.Value + "/" + progressBar.Maximum + ")";
                    else
                        statusLabel.Text = "";

                this.progressBar.Owner.Refresh();
            }
        }

        public void WorkFinished()
        {
            if (this.progressBar.Owner.InvokeRequired)
                this.progressBar.Owner.Invoke(new SimpleDelegate(this.WorkFinished));
            else
            {
                progressBar.Visible = false;
                progressBar.Value = 0;
                if (statusLabel != null)
                    statusLabel.Text = "";

                this.progressBar.Owner.Refresh();
            }
        }

        public void WorkCorrectPartCount(int partCounts)
        {
            this.partCounts = partCounts;

            DoCorrectPartCount();
        }

        private void DoCorrectPartCount()
        {
            if (this.progressBar.Owner.InvokeRequired)
                this.progressBar.Owner.Invoke(new SimpleDelegate(this.DoCorrectPartCount));
            else
            {

                if ( progressBar.Value > partCounts)
                    progressBar.Value = partCounts;
                progressBar.Maximum = partCounts;

                if (statusLabel != null)
                    if (progressBar.Value > 0 && progressBar.Maximum > 3)
                        statusLabel.Text = "(" + progressBar.Value + "/" + progressBar.Maximum + ")";
                    else
                        statusLabel.Text = "";

                if (progressBar.Maximum > 3)
                    progressBar.Visible = true;

                this.progressBar.Owner.Refresh();
            }
          
        }
        #endregion
    }
}